<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://www.finn.pl/schema/fupo" xmlns:ns2="http://uri.etsi.org/01903/v1.3.2#">
<xsl:template match="/">
  <html>
  <head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<title>UPO</title>
<style type="text/css">
body, *{
font-family: Arial, Verdana, sans-serif;
}
p{
font-size:16px;
margin: 25px;	
line-height: 30px;
}
h3{
background-color: #c8def2;
text-align: center;
line-height: 50px;
margin: 20px;
border: 1px solid #a8bed2;
font-size:30px;
}
div.znak{
border:none;
font-size:24px;
font-weight: bold;
text-align:center;
}
span{
font-weight: bold;
}
div{
border: 1px solid #a8bed2;
margin: 20px;
}
</style>
  </head>
  <body>
  <h3>Urzędowe Poświadczenie Odbioru</h3>
  <div><p>To jest urzędowe poświadczenie odbioru wystawione przez <xsl:value-of select="//ns1:nazwa"/> w dniu <xsl:value-of select="substring-before(//ns1:data, 'T')"/> o godzinie <xsl:value-of select="substring-after(//ns1:data, 'T')"/>.<br />
  Adresatem dokumentów jest <xsl:value-of select="//ns1:adresat"/>.<br />
Data odebrania: <xsl:value-of select="//ns1:data_odebrania"/>.<br />
Niniejszy dokument potwierdza, że pismo oznaczone symbolem "<xsl:value-of select="//ns1:znak"/>" zostało doręczone do Adresata w dniu <xsl:value-of select="//ns1:data_odebrania"/>, co potwierdził on własnym podpisem elektronicznym.<br />
<xsl:if test="//ns2:SigningTime">
Urzędowe Poświadczenie Odbioru wygenerowano i podpisano dnia <xsl:value-of select="substring-before(//ns2:SigningTime, 'T')" /> o godzinie <xsl:value-of select="substring-before(substring-after(//ns2:SigningTime, 'T'), 'Z')"/> czasu uniwersalnego UTC.<br/>
</xsl:if>

</p>
  </div>
  
  </body>
  </html>
</xsl:template>	
</xsl:stylesheet>
